/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DeadRingersEffect
extends OneShotEffect {
    DeadRingersEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy two target nonblack creatures unless either one is a color the other isn't. They can't be regenerated.";
    }

    private DeadRingersEffect(DeadRingersEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeadRingersEffect copy() {
        return new DeadRingersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.size() < 2) {
            return false;
        }
        Permanent first = (Permanent)permanents.get(0);
        Permanent second = (Permanent)permanents.get(1);
        if (!first.getColor(game).equals((Object)second.getColor(game))) {
            return false;
        }
        first.destroy(source, game, true);
        second.destroy(source, game, true);
        return true;
    }
}

