/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DeadbridgeChantEffect
extends OneShotEffect {
    DeadbridgeChantEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "choose a card at random in your graveyard. If it's a creature card, put it onto the battlefield. Otherwise, put it into your hand";
    }

    private DeadbridgeChantEffect(DeadbridgeChantEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeadbridgeChantEffect copy() {
        return new DeadbridgeChantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.getGraveyard().isEmpty() && (card = controller.getGraveyard().getRandom(game)) != null) {
            Zone targetZone = Zone.HAND;
            String text = " put into hand of ";
            if (card.isCreature(game)) {
                targetZone = Zone.BATTLEFIELD;
                text = " put onto battlefield for ";
            }
            controller.moveCards(card, targetZone, source, game);
            game.informPlayers("Deadbridge Chant: " + card.getName() + text + controller.getLogName());
            return true;
        }
        return false;
    }
}

