/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInOpponentsGraveyard;

class DeadlyCoverUpEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    DeadlyCoverUpEffect() {
        super(true, "its owner's", "any number of cards with the same name as that card", true);
        this.staticText = "exile a card from an opponent's graveyard. Then search its owner's graveyard, hand, and library for any number of cards with that name and exile them. That player shuffles, then draws a card for each card exiled from their hand this way.";
    }

    private DeadlyCoverUpEffect(DeadlyCoverUpEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public DeadlyCoverUpEffect copy() {
        return new DeadlyCoverUpEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        TargetCardInOpponentsGraveyard target = new TargetCardInOpponentsGraveyard(StaticFilters.FILTER_CARD);
        target.withNotTarget(true);
        if (player != null && player.chooseTarget(Outcome.Exile, (Target)target, source, game)) {
            Card cardToExile = game.getCard(target.getFirstTarget());
            if (cardToExile == null) {
                return false;
            }
            player.moveCards(cardToExile, Zone.EXILED, source, game);
            this.applySearchAndExile(game, source, cardToExile.getName(), cardToExile.getOwnerId());
        }
        return true;
    }
}

