/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DeathBegetsLifeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("creature or enchantment");

    DeathBegetsLifeEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures and enchantments. Draw a card for each permanent destroyed this way";
    }

    private DeathBegetsLifeEffect(DeathBegetsLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathBegetsLifeEffect copy() {
        return new DeathBegetsLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int destroyedPermanent = 0;
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, controller.getId(), game)) {
                if (!permanent.destroy(source, game)) continue;
                ++destroyedPermanent;
            }
            if (destroyedPermanent > 0) {
                game.processAction();
                controller.drawCards(destroyedPermanent, source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

