/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.DragonToken2;
import mage.players.Player;

class DeathByDragonsEffect
extends OneShotEffect {
    DeathByDragonsEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player other than target player creates a 5/5 red Dragon creature token with flying";
    }

    private DeathByDragonsEffect(DeathByDragonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathByDragonsEffect copy() {
        return new DeathByDragonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                if (playerId.equals(this.getTargetPointer().getFirst(game, source))) continue;
                DragonToken2 token = new DragonToken2();
                token.putOntoBattlefield(1, game, source, playerId);
            }
            return true;
        }
        return false;
    }
}

