/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class DeathOrGloryEffect
extends OneShotEffect {
    DeathOrGloryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Separate all creature cards in your graveyard into two piles. Exile the pile of an opponent's choice and return the other to the battlefield";
    }

    private DeathOrGloryEffect(DeathOrGloryEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathOrGloryEffect copy() {
        return new DeathOrGloryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
            if (!cards.isEmpty()) {
                TargetCard targetCards = new TargetCard(0, cards.size(), Zone.GRAVEYARD, new FilterCard("cards to put in the first pile"));
                ArrayList<Card> pile1 = new ArrayList<Card>();
                if (controller.choose(Outcome.Neutral, (Cards)cards, targetCards, source, game)) {
                    List targets = targetCards.getTargets();
                    for (UUID targetId : targets) {
                        Card card = cards.get(targetId, game);
                        if (card == null) continue;
                        pile1.add(card);
                        cards.remove(card);
                    }
                }
                ArrayList pile2 = new ArrayList(cards.getCards(game));
                StringBuilder sb = new StringBuilder("First pile of ").append(controller.getLogName()).append(": ");
                sb.append(pile1.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
                game.informPlayers(sb.toString());
                sb = new StringBuilder("Second pile of ").append(controller.getLogName()).append(": ");
                sb.append(pile2.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
                game.informPlayers(sb.toString());
                Set opponents = game.getOpponents(source.getControllerId());
                if (!opponents.isEmpty()) {
                    TargetOpponent targetOpponent;
                    Player opponent = game.getPlayer((UUID)opponents.iterator().next());
                    if (opponents.size() > 1 && controller.chooseTarget(Outcome.Neutral, (Target)(targetOpponent = new TargetOpponent(true)), source, game)) {
                        opponent = game.getPlayer(targetOpponent.getFirstTarget());
                        game.informPlayers(controller.getLogName() + " chose " + opponent.getLogName() + " to choose their pile");
                    }
                    if (opponent != null) {
                        boolean choice = opponent.choosePile(this.outcome, "Choose a pile to put onto the battlefield.", pile1, pile2, game);
                        Zone pile1Zone = Zone.EXILED;
                        Zone pile2Zone = Zone.BATTLEFIELD;
                        if (choice) {
                            pile1Zone = Zone.BATTLEFIELD;
                            pile2Zone = Zone.EXILED;
                        }
                        HashSet pile1Set = new HashSet(pile1);
                        HashSet pile2Set = new HashSet(pile2);
                        controller.moveCards(pile1Set, pile1Zone, source, game, false, false, false, null);
                        controller.moveCards(pile2Set, pile2Zone, source, game, false, false, false, null);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

