/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class DeepCaverBatEffect
extends OneShotEffect {
    DeepCaverBatEffect() {
        super(Outcome.Exile);
        this.staticText = "look at target opponent's hand. You may exile a nonland card from it until {this} leaves the battlefield";
    }

    private DeepCaverBatEffect(DeepCaverBatEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeepCaverBatEffect copy() {
        return new DeepCaverBatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null || opponent.getHand().isEmpty()) {
            return false;
        }
        MageObject sourceObj = source.getSourceObject(game);
        controller.lookAtCards(sourceObj == null ? null : sourceObj.getIdName(), opponent.getHand(), game);
        Permanent bat = source.getSourcePermanentIfItStillExists(game);
        if (bat == null) {
            return true;
        }
        TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
        controller.choose(this.outcome, opponent.getHand(), target, source, game);
        Card card = opponent.getHand().get(target.getFirstTarget(), game);
        if (card == null) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        controller.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), bat.getIdName());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(Zone.HAND), source);
        return true;
    }
}

