/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInLibrary;
import mage.watchers.common.PlayLandWatcher;

class DeepGnomeTerramancerTriggeredAbility
extends TriggeredAbilityImpl {
    DeepGnomeTerramancerTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        FilterCard filter = new FilterCard("Plains card");
        filter.add((Predicate)SubType.PLAINS.getPredicate());
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        this.addEffect((Effect)new SearchLibraryPutInPlayEffect(target, true));
    }

    private DeepGnomeTerramancerTriggeredAbility(DeepGnomeTerramancerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent land = game.getPermanent(event.getTargetId());
        PlayLandWatcher watcher = (PlayLandWatcher)game.getState().getWatcher(PlayLandWatcher.class);
        if (land == null || !land.isLand(game)) {
            return false;
        }
        if (land.isControlledBy(this.controllerId)) {
            return false;
        }
        return !watcher.wasLandPlayed(land, game);
    }

    public DeepGnomeTerramancerTriggeredAbility copy() {
        return new DeepGnomeTerramancerTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more lands enter the battlefield under an opponent's control without being played, you may search your library for a Plains card, put it onto the battlefield tapped, then shuffle. Do this only once each turn.";
    }
}

