/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesBasicLandTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DeepwoodElderEffect
extends OneShotEffect {
    DeepwoodElderEffect() {
        super(Outcome.LoseAbility);
        this.staticText = "X target lands become Forests until end of turn";
    }

    private DeepwoodElderEffect(DeepwoodElderEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeepwoodElderEffect copy() {
        return new DeepwoodElderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Target target : source.getTargets()) {
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                BecomesBasicLandTargetEffect effect = new BecomesBasicLandTargetEffect(Duration.EndOfTurn, new SubType[]{SubType.FOREST});
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }
}

