/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DefiantVanguardTriggeredAbility
extends TriggeredAbilityImpl {
    DefiantVanguardTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
    }

    private DefiantVanguardTriggeredAbility(DefiantVanguardTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DefiantVanguardTriggeredAbility copy() {
        return new DefiantVanguardTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED && event.getSourceId().equals(this.getSourceId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent blocker = game.getPermanent(event.getSourceId());
        Permanent blocked = game.getPermanent(event.getTargetId());
        if (blocker != null && blocked != null) {
            game.getState().setValue("DefiantVanguardEffect_" + blocked.getId(), (Object)blocked.getZoneChangeCounter(game));
            game.getState().setValue("DefiantVanguardEffect_" + blocker.getId(), (Object)blocker.getZoneChangeCounter(game));
            this.getAllEffects().setTargetPointer((TargetPointer)new FixedTarget(blocked.getId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "When {this} blocks, at end of combat, destroy it and all creatures it blocked this turn.";
    }
}

