/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DefyDeathEffect
extends OneShotEffect {
    DefyDeathEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If it's an Angel, put two +1/+1 counters on it";
    }

    private DefyDeathEffect(DefyDeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public DefyDeathEffect copy() {
        return new DefyDeathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.hasSubtype(SubType.ANGEL, game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }
}

