/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.common.EndOfCombatTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DelinaWildMageEffect
extends OneShotEffect {
    DelinaWildMageEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature you control, then roll a d20.<br>1-14 | Create a tapped and attacking token that's a copy of that creature, except it's not legendary and it has \"At end of combat, exile this token.\"<br>15-20 | Create one of those tokens. You may roll again.";
    }

    private DelinaWildMageEffect(DelinaWildMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public DelinaWildMageEffect copy() {
        return new DelinaWildMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int result;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, true, true);
        effect.setIsntLegendary(true);
        effect.addAdditionalAbilities(new Ability[]{new EndOfCombatTriggeredAbility((Effect)new ExileSourceEffect(), false)});
        effect.setTargetPointer(this.getTargetPointer().copy());
        do {
            result = player.rollDice(this.outcome, source, game, 20);
            effect.apply(game, source);
        } while (result >= 15 && 20 >= result && player.chooseUse(this.outcome, "Roll again?", source, game));
        return true;
    }
}

