/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.CastOnlyIfConditionIsTrueAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.OnOpponentsTurnCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.d.DeliriumEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIsActivePlayerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class Delirium
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public Delirium(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{B}{R}");
        this.addAbility((Ability)new CastOnlyIfConditionIsTrueAbility((Condition)OnOpponentsTurnCondition.instance, "Cast this spell only during an opponent's turn."));
        this.getSpellAbility().addEffect((Effect)new TapTargetEffect("tap target creature that player controls"));
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.getSpellAbility().addEffect((Effect)new DeliriumEffect());
        this.getSpellAbility().addEffect((Effect)new PreventDamageToTargetEffect(Duration.EndOfTurn, true).setText("Prevent all combat damage that would be dealt to"));
        this.getSpellAbility().addEffect((Effect)new PreventDamageByTargetEffect(Duration.EndOfTurn, true).setText("and dealt by the creature this turn."));
    }

    private Delirium(Delirium card) {
        super((CardImpl)card);
    }

    public Delirium copy() {
        return new Delirium(this);
    }

    static {
        filter.add((Predicate)ControllerIsActivePlayerPredicate.instance);
    }
}

