/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetOpponent;

class DeliverUntoEvilEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPlaneswalkerPermanent(SubType.BOLAS);
    private static final FilterCard filter2 = new FilterCard("cards (to leave in the graveyard)");

    DeliverUntoEvilEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose up to four target cards in your graveyard. If you control a Bolas planeswalker, return those cards to your hand. Otherwise, an opponent chooses two of them. Leave the chosen cards in your graveyard and put the rest into your hand.<br>";
    }

    private DeliverUntoEvilEffect(DeliverUntoEvilEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeliverUntoEvilEffect copy() {
        return new DeliverUntoEvilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)((Target)source.getTargets().get(0)).getTargets());
        if (cards.isEmpty()) {
            return false;
        }
        if (!game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game).isEmpty()) {
            return player.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        TargetOpponent targetOpponent = new TargetOpponent();
        targetOpponent.withNotTarget(true);
        if (!player.choose(this.outcome, (Target)targetOpponent, source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        TargetCardInGraveyard targetCard = new TargetCardInGraveyard(Math.min(2, cards.size()), filter2);
        if (!opponent.choose(this.outcome, (Cards)cards, (TargetCard)targetCard, source, game)) {
            return false;
        }
        cards.removeAll((Collection)targetCard.getTargets());
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }
}

