/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;

class DelugeOfTheDeadEffect
extends OneShotEffect {
    DelugeOfTheDeadEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card from a graveyard. If it was a creature card, create a 2/2 black Zombie creature token";
    }

    private DelugeOfTheDeadEffect(DelugeOfTheDeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public DelugeOfTheDeadEffect copy() {
        return new DelugeOfTheDeadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (card.isCreature(game)) {
            new ZombieToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

