/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DementiaSliverEffect
extends OneShotEffect {
    DementiaSliverEffect() {
        super(Outcome.Damage);
        this.staticText = "Target opponent reveals a card at random from their hand. If that card has the chosen name, that player discards it";
    }

    private DementiaSliverEffect(DementiaSliverEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (opponent != null && sourceObject != null && cardName != null && !cardName.isEmpty()) {
            if (!opponent.getHand().isEmpty()) {
                CardsImpl revealed = new CardsImpl();
                Card card = opponent.getHand().getRandom(game);
                if (card != null) {
                    revealed.add(card);
                    opponent.revealCards(sourceObject.getName(), (Cards)revealed, game);
                    if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
                        opponent.discard(card, false, source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public DementiaSliverEffect copy() {
        return new DementiaSliverEffect(this);
    }
}

