/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class DemilichPlayEffect
extends AsThoughEffectImpl {
    DemilichPlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard by exiling four instant and/or sorcery cards from your graveyard in addition to paying its other costs";
    }

    private DemilichPlayEffect(DemilichPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public DemilichPlayEffect copy() {
        return new DemilichPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Player controller;
        if (source.getSourceId().equals(objectId) && source.isControlledBy(affectedControllerId) && game.getState().getZone(objectId) == Zone.GRAVEYARD && (controller = game.getPlayer(affectedControllerId)) != null) {
            CostsImpl costs = new CostsImpl();
            costs.add((Object)new ExileFromGraveCost(new TargetCardInYourGraveyard(4, StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY_FROM_YOUR_GRAVEYARD)));
            controller.setCastSourceIdWithAlternateMana(objectId, (ManaCosts)new ManaCostsImpl("{U}{U}{U}{U}"), (Costs)costs, MageIdentifier.DemilichAlternateCast);
            return true;
        }
        return false;
    }
}

