/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class DemonicBargainEffect
extends OneShotEffect {
    DemonicBargainEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top thirteen cards of your library, then search your library for a card. Put that card into your hand, then shuffle";
    }

    private DemonicBargainEffect(DemonicBargainEffect effect) {
        super((OneShotEffect)effect);
    }

    public DemonicBargainEffect copy() {
        return new DemonicBargainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.moveCards(player.getLibrary().getTopCards(game, 13), Zone.EXILED, source, game);
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

