/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Arrays;
import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DemonicCovenantEffect
extends OneShotEffect {
    DemonicCovenantEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then mill two cards. If two cards that share all their card types were milled this way, sacrifice {this}";
    }

    private DemonicCovenantEffect(DemonicCovenantEffect effect) {
        super((OneShotEffect)effect);
    }

    public DemonicCovenantEffect copy() {
        return new DemonicCovenantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(2, source, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        return cards.size() >= 2 && permanent != null && CardUtil.checkAnyPairs((Collection)cards.getCards(game), (c1, c2) -> Arrays.stream(CardType.values()).allMatch(cardType -> c1.getCardType(game).contains(cardType) == c2.getCardType(game).contains(cardType))) && permanent.sacrifice(source, game);
    }
}

