/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetControlledPermanent;

class DescentIntoMadnessEffect
extends OneShotEffect {
    DescentIntoMadnessEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "put a despair counter on {this}, then each player exiles X permanents they control and/or cards from their hand, where X is the number of despair counters on {this}";
    }

    private DescentIntoMadnessEffect(DescentIntoMadnessEffect effect) {
        super((OneShotEffect)effect);
    }

    public DescentIntoMadnessEffect copy() {
        return new DescentIntoMadnessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && controller != null) {
            sourcePermanent.addCounters(CounterType.DESPAIR.createInstance(), source.getControllerId(), source, game);
        }
        if (sourcePermanent == null) {
            sourcePermanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (sourcePermanent != null && controller != null) {
            int count = sourcePermanent.getCounters(game).getCount(CounterType.DESPAIR);
            if (count > 0) {
                LinkedList<UUID> selectedObjects = new LinkedList<UUID>();
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    Player currentPlayer = game.getPlayer(playerId);
                    if (currentPlayer == null || !currentPlayer.canRespond()) continue;
                    this.selectCards(currentPlayer, selectedObjects, count, source, game);
                }
                for (UUID objectId : selectedObjects) {
                    Card card;
                    Player player;
                    if (game.getState().getZone(objectId) == Zone.BATTLEFIELD) {
                        Permanent permanent = game.getPermanent(objectId);
                        if (permanent == null || (player = game.getPlayer(permanent.getControllerId())) == null) continue;
                        player.moveCardToExileWithInfo((Card)permanent, null, "", source, game, Zone.BATTLEFIELD, true);
                        continue;
                    }
                    if (game.getState().getZone(objectId) != Zone.HAND || (card = game.getCard(objectId)) == null || (player = game.getPlayer(card.getOwnerId())) == null) continue;
                    player.moveCardToExileWithInfo(card, null, "", source, game, Zone.HAND, true);
                }
            }
            return true;
        }
        return false;
    }

    private void selectCards(Player player, List<UUID> selectedObjects, int count, Ability source, Game game) {
        int amount = Math.min(count, player.getHand().size() + game.getBattlefield().getAllActivePermanents(player.getId()).size());
        int cardsFromHand = 0;
        while (player.canRespond() && amount > 0) {
            TargetCard targetInHand;
            TargetControlledPermanent target;
            do {
                FilterControlledPermanent filter = new FilterControlledPermanent();
                filter.setMessage("permanent you control (" + amount + " left in total)");
                ArrayList<PermanentIdPredicate> uuidPredicates = new ArrayList<PermanentIdPredicate>();
                for (UUID uuid : selectedObjects) {
                    uuidPredicates.add(new PermanentIdPredicate(uuid));
                }
                filter.add(Predicates.not((Predicate)Predicates.or(uuidPredicates)));
                target = new TargetControlledPermanent(0, 1, filter, true);
                if (!target.canChoose(player.getId(), source, game) || !player.choose(Outcome.Exile, (Target)target, source, game)) continue;
                for (Object targetId : target.getTargets()) {
                    Permanent chosen;
                    if (selectedObjects.contains(targetId) || (chosen = game.getPermanent((UUID)targetId)) == null) continue;
                    --amount;
                    game.informPlayers(player.getLogName() + " selects " + chosen.getLogName() + " from battlefield");
                    selectedObjects.add((UUID)targetId);
                }
            } while (amount > 0 && !target.getTargets().isEmpty() && player.canRespond());
            if (amount <= 0) continue;
            do {
                Card card;
                Object targetId;
                FilterCard filterInHand = new FilterCard();
                filterInHand.setMessage("card from your hand (" + amount + " left in total)");
                targetInHand = new TargetCard(0, 1, Zone.HAND, filterInHand);
                ArrayList<CardIdPredicate> uuidPredicates = new ArrayList<CardIdPredicate>();
                targetId = selectedObjects.iterator();
                while (targetId.hasNext()) {
                    UUID uuid = (UUID)targetId.next();
                    uuidPredicates.add(new CardIdPredicate(uuid));
                }
                filterInHand.add(Predicates.not((Predicate)Predicates.or(uuidPredicates)));
                if (!targetInHand.canChoose(player.getId(), source, game) || !player.choose(Outcome.Exile, player.getHand(), targetInHand, source, game) || (card = player.getHand().get(targetInHand.getFirstTarget(), game)) == null) continue;
                selectedObjects.add(targetInHand.getFirstTarget());
                --amount;
                ++cardsFromHand;
            } while (amount > 0 && !targetInHand.getTargets().isEmpty() && player.canRespond());
        }
        if (cardsFromHand > 0) {
            game.informPlayers(player.getLogName() + " selects " + cardsFromHand + (cardsFromHand == 1 ? " card" : " cards") + " from their hand");
        }
    }
}

