/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DetentionSphereEntersEffect
extends OneShotEffect {
    DetentionSphereEntersEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile target nonland permanent not named Detention Sphere and all other permanents with the same name as that permanent";
    }

    private DetentionSphereEntersEffect(DetentionSphereEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && exileId != null && targetPermanent != null && controller != null) {
            if (CardUtil.haveEmptyName((MageObject)targetPermanent)) {
                controller.moveCardToExileWithInfo((Card)targetPermanent, exileId, sourceObject.getIdName(), source, game, Zone.BATTLEFIELD, true);
            } else {
                String name = targetPermanent.getName();
                for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
                    if (permanent == null || !CardUtil.haveSameNames((MageObject)permanent, (String)name, (Game)game)) continue;
                    controller.moveCardToExileWithInfo((Card)permanent, exileId, sourceObject.getIdName(), source, game, Zone.BATTLEFIELD, true);
                }
            }
            return true;
        }
        return false;
    }

    public DetentionSphereEntersEffect copy() {
        return new DetentionSphereEntersEffect(this);
    }
}

