/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromExileForSourceEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;
import org.apache.log4j.Logger;

class DetentionSphereLeavesEffect
extends OneShotEffect {
    DetentionSphereLeavesEffect() {
        super(Outcome.Neutral);
        this.staticText = "return the exiled cards to the battlefield under their owner's control";
    }

    private DetentionSphereLeavesEffect(DetentionSphereLeavesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && controller != null) {
            Permanent permanentLeftBattlefield = (Permanent)this.getValue("permanentLeftBattlefield");
            if (permanentLeftBattlefield == null) {
                Logger.getLogger(ReturnFromExileForSourceEffect.class).error((Object)("Permanent not found: " + sourceObject.getName()));
                return false;
            }
            ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)permanentLeftBattlefield.getZoneChangeCounter(game)));
            if (exile != null) {
                controller.moveCards(exile.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            }
            return true;
        }
        return false;
    }

    public DetentionSphereLeavesEffect copy() {
        return new DetentionSphereLeavesEffect(this);
    }
}

