/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DevastatingOnslaughtEffect
extends OneShotEffect {
    DevastatingOnslaughtEffect() {
        super(Outcome.Benefit);
        this.staticText = "create X tokens that are copies of target artifact or creature you control. Those tokens gain haste until end of turn. Sacrifice them at the beginning of the next end step";
    }

    private DevastatingOnslaughtEffect(DevastatingOnslaughtEffect effect) {
        super((OneShotEffect)effect);
    }

    public DevastatingOnslaughtEffect copy() {
        return new DevastatingOnslaughtEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        if (permanent == null || xValue < 1) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.setHasHaste(true);
        effect.setSavedPermanent(permanent);
        effect.apply(game, source);
        effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

