/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DevouringGreedEffect
extends OneShotEffect {
    DevouringGreedEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Target player loses 2 life plus 2 life for each Spirit sacrificed this way. You gain that much life";
    }

    private DevouringGreedEffect(DevouringGreedEffect effect) {
        super((OneShotEffect)effect);
    }

    public DevouringGreedEffect copy() {
        return new DevouringGreedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int numberSpirits = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            numberSpirits += ((SacrificeTargetCost)cost).getPermanents().size();
        }
        int amount = 2 + numberSpirits * 2;
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && sourcePlayer != null) {
            targetPlayer.loseLife(amount, game, source, false);
            sourcePlayer.gainLife(amount, game, source);
            return true;
        }
        return false;
    }
}

