/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DevouringRageEffect
extends OneShotEffect {
    DevouringRageEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Target creature gets +3/+0 until end of turn. For each Spirit sacrificed this way, that creature gets an additional +3/+0 until end of turn";
    }

    private DevouringRageEffect(DevouringRageEffect effect) {
        super((OneShotEffect)effect);
    }

    public DevouringRageEffect copy() {
        return new DevouringRageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int numberSpirits = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            numberSpirits = ((SacrificeTargetCost)cost).getPermanents().size();
        }
        int amount = 3 + numberSpirits * 3;
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null) {
            BoostTargetEffect effect = new BoostTargetEffect(amount, 0, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

