/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class DevouringTendrilsDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;

    DevouringTendrilsDelayedTriggeredAbility(MageObjectReference mor) {
        super((Effect)new GainLifeEffect(2), Duration.EndOfTurn, false);
        this.mor = mor;
    }

    private DevouringTendrilsDelayedTriggeredAbility(DevouringTendrilsDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && this.mor.refersTo((MageObject)zEvent.getTarget(), game);
    }

    public DevouringTendrilsDelayedTriggeredAbility copy() {
        return new DevouringTendrilsDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When the permanent you don't control dies this turn, you gain 2 life.";
    }
}

