/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.d.DimensionalBreachReturnEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class DimensionalBreachDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    DimensionalBreachDelayedTriggeredAbility(Set<MageObjectReference> morSet) {
        super((Effect)new DimensionalBreachReturnEffect(morSet), Duration.Custom, false, false);
        this.morSet.addAll(morSet);
    }

    private DimensionalBreachDelayedTriggeredAbility(DimensionalBreachDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.morSet.addAll(ability.morSet);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return this.morSet.stream().map(mor -> mor.getCard(game)).anyMatch(Objects::nonNull);
    }

    public DimensionalBreachDelayedTriggeredAbility copy() {
        return new DimensionalBreachDelayedTriggeredAbility(this);
    }

    public boolean isInactive(Game game) {
        return this.morSet.stream().map(mor -> mor.getCard(game)).noneMatch(Objects::nonNull);
    }

    public String getRule() {
        return "For as long as any of those cards remain exiled, at the beginning of each player's upkeep, that player returns one of the exiled cards they own to the battlefield.";
    }
}

