/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.d.DimirDoppelgangerCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class DimirDoppelgangerEffect
extends OneShotEffect {
    DimirDoppelgangerEffect() {
        super(Outcome.Copy);
        this.staticText = "Exile target creature card from a graveyard. {this} becomes a copy of that card, except it has this ability";
    }

    private DimirDoppelgangerEffect(DimirDoppelgangerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DimirDoppelgangerEffect copy() {
        return new DimirDoppelgangerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent dimirDoppelganger = game.getPermanent(source.getSourceId());
        PermanentCard newBluePrint = null;
        if (controller != null && dimirDoppelganger != null) {
            Card copyFromCard = game.getCard(source.getFirstTarget());
            if (copyFromCard != null) {
                CardsImpl cardsToExile = new CardsImpl();
                cardsToExile.add(copyFromCard);
                controller.moveCards((Cards)cardsToExile, Zone.EXILED, source, game);
                newBluePrint = new PermanentCard(copyFromCard, source.getControllerId(), game);
                newBluePrint.assignNewId();
                DimirDoppelgangerCopyApplier applier = new DimirDoppelgangerCopyApplier();
                applier.apply(game, (MageObject)newBluePrint, source, dimirDoppelganger.getId());
                CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)newBluePrint, dimirDoppelganger.getId());
                copyEffect.setApplier((CopyApplier)applier);
                Ability newAbility = source.copy();
                copyEffect.init(newAbility, game);
                game.addEffect((ContinuousEffect)copyEffect, newAbility);
            }
            return true;
        }
        return false;
    }
}

