/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DingusEggTriggeredAbility
extends TriggeredAbilityImpl {
    DingusEggTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2), false);
    }

    private DingusEggTriggeredAbility(DingusEggTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget().isLand(game)) {
            if (this.getTargets().isEmpty()) {
                UUID targetControllerId = zEvent.getTarget().getControllerId();
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(targetControllerId));
                }
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a land is put into a graveyard from the battlefield, {this} deals 2 damage to that land's controller.";
    }

    public DingusEggTriggeredAbility copy() {
        return new DingusEggTriggeredAbility(this);
    }
}

