/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DiregrafScavengerEffect
extends OneShotEffect {
    DiregrafScavengerEffect() {
        super(Outcome.Exile);
        this.staticText = "exile up to one target card from a graveyard. If a creature card was exiled this way, each opponent loses 2 life and you gain 2 life";
    }

    private DiregrafScavengerEffect(DiregrafScavengerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiregrafScavengerEffect copy() {
        return new DiregrafScavengerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card targetCard = game.getCard(source.getFirstTarget());
        if (controller == null || targetCard == null) {
            return false;
        }
        boolean creature = targetCard.isCreature(game);
        if (!controller.moveCards(targetCard, Zone.EXILED, source, game)) {
            return false;
        }
        if (creature) {
            for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null) continue;
                opponent.loseLife(2, game, source, false);
            }
            controller.gainLife(2, game, source);
        }
        return true;
    }
}

