/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.cards.Cards;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class DiscerningTasteEffect
extends LookLibraryAndPickControllerEffect {
    DiscerningTasteEffect() {
        super(4, 1, PutCards.HAND, PutCards.GRAVEYARD);
    }

    private DiscerningTasteEffect(DiscerningTasteEffect effect) {
        super((LookLibraryAndPickControllerEffect)effect);
    }

    public DiscerningTasteEffect copy() {
        return new DiscerningTasteEffect(this);
    }

    protected boolean actionWithPickedCards(Game game, Ability source, Player player, Cards pickedCards, Cards otherCards) {
        super.actionWithPickedCards(game, source, player, pickedCards, otherCards);
        otherCards.retainZone(Zone.GRAVEYARD, game);
        int life = otherCards.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game).stream().map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(0);
        player.gainLife(life, game, source);
        return true;
    }

    public String getText(Mode mode) {
        return super.getText(mode).concat(". You gain life equal to the greatest power among creature cards put into your graveyard this way");
    }
}

