/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DiscipleOfGriselbrandEffect
extends OneShotEffect {
    DiscipleOfGriselbrandEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to the sacrificed creature's toughness";
    }

    private DiscipleOfGriselbrandEffect(DiscipleOfGriselbrandEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiscipleOfGriselbrandEffect copy() {
        return new DiscipleOfGriselbrandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            amount = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getToughness().getValue();
            Player player = game.getPlayer(source.getControllerId());
            if (amount <= 0 || player == null) continue;
            player.gainLife(amount, game, source);
            return true;
        }
        return false;
    }
}

