/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DisciplesOfTheInfernoEffect
extends ReplacementEffectImpl {
    DisciplesOfTheInfernoEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "if a noncreature source you control would deal damage to a creature, battle, or opponent, it deals that much damage plus 2 instead";
    }

    private DisciplesOfTheInfernoEffect(DisciplesOfTheInfernoEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)2));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent;
        block3: {
            block2: {
                Player controller = game.getPlayer(source.getControllerId());
                if (controller == null) break block2;
                if (controller.hasOpponent(event.getTargetId(), game)) break block3;
                if (!Optional.of(event.getTargetId()).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(permanent -> !permanent.isCreature(game) && !permanent.isBattle(game)).orElse(true).booleanValue()) break block3;
            }
            return false;
        }
        Object sourceObject = (sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId())) == null ? game.getObject(event.getSourceId()) : sourcePermanent;
        return sourceObject != null && !sourceObject.isCreature(game) && event.getAmount() > 0;
    }

    public DisciplesOfTheInfernoEffect copy() {
        return new DisciplesOfTheInfernoEffect(this);
    }
}

