/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.Zone;
import mage.filter.predicate.mageobject.OutlawPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class DiscreetRetreatTriggeredAbility
extends TriggeredAbilityImpl {
    DiscreetRetreatTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1, true));
        this.addEffect((Effect)new LoseLifeSourceControllerEffect(1).concatBy("and"));
        this.setTriggerPhrase("Whenever you cast your first outlaw spell each turn, ");
    }

    private DiscreetRetreatTriggeredAbility(DiscreetRetreatTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DiscreetRetreatTriggeredAbility copy() {
        return new DiscreetRetreatTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher == null) {
            return false;
        }
        List outlawSpells = watcher.getSpellsCastThisTurn(this.getControllerId()).stream().filter(Objects::nonNull).filter(s -> OutlawPredicate.instance.apply((MageObject)s, game)).collect(Collectors.toList());
        return outlawSpells.size() == 1 && ((Spell)outlawSpells.get(0)).getId().equals(event.getTargetId());
    }
}

