/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.common.BecomesTargetSourceTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.CreaturesBecomeOtherTypeEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DismissIntoDreamEffect
extends CreaturesBecomeOtherTypeEffect {
    DismissIntoDreamEffect(FilterPermanent filter) {
        super(filter, SubType.ILLUSION, Duration.WhileOnBattlefield);
        this.outcome = Outcome.Detriment;
        this.staticText = this.staticText + " and has \"When this creature becomes the target of a spell or ability, sacrifice it.\"";
    }

    private DismissIntoDreamEffect(DismissIntoDreamEffect effect) {
        super((CreaturesBecomeOtherTypeEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public DismissIntoDreamEffect copy() {
        return new DismissIntoDreamEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        super.apply(layer, sublayer, source, game);
        if (layer == Layer.AbilityAddingRemovingEffects_6) {
            for (Permanent object : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), game)) {
                object.addAbility((Ability)new BecomesTargetSourceTriggeredAbility((Effect)new SacrificeSourceEffect()), source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return super.hasLayer(layer) || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

