/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Objects;
import java.util.stream.Collectors;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

class DisorderEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent("white creature");

    public DisorderEffect() {
        super(Outcome.Damage);
        this.staticText = "and each player who controls a white creature";
    }

    private DisorderEffect(DisorderEffect effect) {
        super((OneShotEffect)effect);
    }

    public DisorderEffect copy() {
        return new DisorderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Player player : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().filter(Objects::nonNull).map(Controllable::getControllerId).distinct().map(arg_0 -> ((Game)game).getPlayer(arg_0)).collect(Collectors.toList())) {
            player.damage(2, source.getSourceId(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

