/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandFromBattlefieldAllEffect;
import mage.abilities.effects.common.discard.DiscardEachPlayerEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class DispersalEffect
extends OneShotEffect {
    DispersalEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent returns a nonland permanent they control with the highest mana value among permanents they control to its owner's hand, then discards a card.";
    }

    private DispersalEffect(DispersalEffect effect) {
        super((OneShotEffect)effect);
    }

    public DispersalEffect copy() {
        return new DispersalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HashSet<PermanentIdPredicate> permsToReturn = new HashSet<PermanentIdPredicate>();
        for (UUID opponentId : game.getOpponents(player.getId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            int highestCMC = 0;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(opponentId)) {
                if (permanent == null) continue;
                highestCMC = Math.max(highestCMC, permanent.getManaValue());
            }
            FilterNonlandPermanent filter = new FilterNonlandPermanent("permanent you control with mana value " + highestCMC);
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, highestCMC));
            filter.add((Predicate)new ControllerIdPredicate(opponentId));
            TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
            if (!opponent.choose(this.outcome, (Target)target, source, game) || target.getFirstTarget() == null) continue;
            permsToReturn.add(new PermanentIdPredicate(target.getFirstTarget()));
        }
        FilterPermanent filter = new FilterPermanent();
        filter.add(Predicates.or(permsToReturn));
        new ReturnToHandFromBattlefieldAllEffect(filter).apply(game, source);
        new DiscardEachPlayerEffect((DynamicValue)StaticValue.get((int)1), false, TargetController.OPPONENT).apply(game, source);
        return true;
    }
}

