/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class DisruptorFluteCostEffect
extends ContinuousRuleModifyingEffectImpl {
    DisruptorFluteCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Activated abilities of sources with the chosen name can't be activated unless they're mana abilities";
    }

    private DisruptorFluteCostEffect(DisruptorFluteCostEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DisruptorFluteCostEffect copy() {
        return new DisruptorFluteCostEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
        if (ability.isPresent() && object != null) {
            return game.getState().getPlayersInRange(source.getControllerId(), game).contains((Object)event.getPlayerId()) && !((Ability)ability.get()).isManaAbility() && CardUtil.haveSameNames((MageObject)object, (String)cardName, (Game)game);
        }
        return false;
    }
}

