/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DissatisfiedCustomerEffect
extends OneShotEffect {
    DissatisfiedCustomerEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. If the result is 3 or less, you lose that much life";
    }

    private DissatisfiedCustomerEffect(DissatisfiedCustomerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DissatisfiedCustomerEffect copy() {
        return new DissatisfiedCustomerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 6);
        if (result <= 3) {
            player.loseLife(result, game, source, false);
        }
        return true;
    }
}

