/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class DistendedMindbenderEffect
extends OneShotEffect {
    private static final FilterCard filterFourOrGreater = new FilterCard("a card from it with mana value 4 or greater");
    private static final FilterCard filterThreeOrLess = new FilterCard("a nonland card from it with mana value 3 or less");

    public DistendedMindbenderEffect() {
        super(Outcome.Discard);
        this.staticText = "target opponent reveals their hand. You choose from it a nonland card with mana value 3 or less and a card with mana value 4 or greater. That player discards those cards.";
    }

    private DistendedMindbenderEffect(DistendedMindbenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public DistendedMindbenderEffect copy() {
        return new DistendedMindbenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent == null || controller == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        TargetCard targetThreeOrLess = new TargetCard(1, Zone.HAND, filterThreeOrLess);
        TargetCard targetFourOrGreater = new TargetCard(1, Zone.HAND, filterFourOrGreater);
        CardsImpl toDiscard = new CardsImpl();
        if (controller.choose(Outcome.Benefit, opponent.getHand(), targetThreeOrLess, source, game)) {
            toDiscard.addAll((Collection)targetThreeOrLess.getTargets());
        }
        if (controller.choose(Outcome.Benefit, opponent.getHand(), targetFourOrGreater, source, game)) {
            toDiscard.addAll((Collection)targetFourOrGreater.getTargets());
        }
        opponent.discard((Cards)toDiscard, false, source, game);
        return true;
    }

    static {
        filterFourOrGreater.add((Predicate)new ManaValuePredicate(ComparisonType.MORE_THAN, 3));
        filterThreeOrLess.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
        filterThreeOrLess.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
    }
}

