/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class DivineGambitEffect
extends OneShotEffect {
    DivineGambitEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "That player may put a permanent card from their hand onto the battlefield";
    }

    private DivineGambitEffect(DivineGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivineGambitEffect copy() {
        return new DivineGambitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCardInHand target;
        Player player;
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getFirstTarget());
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null && player.chooseUse(this.outcome, "Put a permanent card from your hand onto the battlefield?", source, game) && player.chooseTarget(this.outcome, (Target)(target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_PERMANENT)), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            return player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return false;
    }
}

