/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.d.DivineInterventionDrawEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DivineInterventionAbility
extends TriggeredAbilityImpl {
    DivineInterventionAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DivineInterventionDrawEffect(), false);
        this.setTriggerPhrase("When you remove the last intervention counter from {this}, ");
    }

    private DivineInterventionAbility(DivineInterventionAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DivineInterventionAbility copy() {
        return new DivineInterventionAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_REMOVED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!(event.getData().equals(CounterType.INTERVENTION.getName()) && this.getSourceId().equals(event.getTargetId()) && this.getControllerId().equals(event.getPlayerId()))) {
            return false;
        }
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.INTERVENTION) == 0;
    }
}

