/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DivineSmiteEffect
extends OneShotEffect {
    DivineSmiteEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature or planeswalker an opponent controls phases out. If that permanent is black, exile it instead";
    }

    private DivineSmiteEffect(DivineSmiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivineSmiteEffect copy() {
        return new DivineSmiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (!permanent.getColor(game).isBlack()) {
            permanent.phaseOut(game);
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.moveCards((Card)permanent, Zone.EXILED, source, game);
    }
}

