/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class DivinerOfMistReplacementEffect
extends ReplacementEffectImpl {
    public DivinerOfMistReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Exile);
        this.staticText = "If that spell would be put into your graveyard, exile it instead.";
    }

    protected DivinerOfMistReplacementEffect(DivinerOfMistReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DivinerOfMistReplacementEffect copy() {
        return new DivinerOfMistReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        MageObjectReference card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = (MageObjectReference)game.getState().getValue("DivinerOfMist")) != null) {
            ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (Zone.GRAVEYARD == ((ZoneChangeEvent)event).getToZone()) {
            Card eventCard = game.getCard(event.getSourceId());
            MageObjectReference cardMor = (MageObjectReference)game.getState().getValue("DivinerOfMist");
            if (eventCard != null && cardMor != null) {
                int zcc = eventCard.getZoneChangeCounter(game);
                return eventCard.getId().equals(cardMor.getSourceId()) && zcc == cardMor.getZoneChangeCounter() + 1;
            }
        }
        return false;
    }
}

