/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInHand;

class DokuchiSilencerTriggeredAbility
extends TriggeredAbilityImpl {
    DokuchiSilencerTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private DokuchiSilencerTriggeredAbility(DokuchiSilencerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DokuchiSilencerTriggeredAbility copy() {
        return new DokuchiSilencerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player opponent = game.getPlayer(event.getPlayerId());
        if (opponent == null || !event.getSourceId().equals(this.getSourceId()) || !((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        FilterCreatureOrPlaneswalkerPermanent filter = new FilterCreatureOrPlaneswalkerPermanent("creature or planeswalker" + opponent.getLogName() + " controls");
        filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false, "destroy target creature or planeswalker that player controls");
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.getEffects().clear();
        this.addEffect((Effect)new DoWhenCostPaid(ability, (Cost)new DiscardTargetCost(new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE)), "Discard a creature card?"));
        return true;
    }

    public String getRule() {
        return "Whenever {this} deals combat damage to a player, you may discard a creature card. When you do, destroy target creature or planeswalker that player controls.";
    }
}

