/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CantBeCounteredControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class DomriAnarchOfBolasEffect
extends OneShotEffect {
    DomriAnarchOfBolasEffect() {
        super(Outcome.Benefit);
        this.staticText = "Add {R} or {G}. Creature spells you cast this turn can't be countered.";
    }

    private DomriAnarchOfBolasEffect(DomriAnarchOfBolasEffect effect) {
        super((OneShotEffect)effect);
    }

    public DomriAnarchOfBolasEffect copy() {
        return new DomriAnarchOfBolasEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Mana mana = new Mana();
        if (player.chooseUse(this.outcome, "Choose a color of mana to add", null, "Red", "Green", source, game)) {
            mana.increaseRed();
        } else {
            mana.increaseGreen();
        }
        player.getManaPool().addMana(mana, game, source);
        game.addEffect((ContinuousEffect)new CantBeCounteredControlledEffect((FilterSpell)StaticFilters.FILTER_SPELL_A_CREATURE, Duration.EndOfTurn), source);
        return true;
    }
}

