/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.cards.d.DomriChaosBringerTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DomriChaosBringerEffect
extends OneShotEffect {
    DomriChaosBringerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Add {R} or {G}. If that mana is spent on a creature spell, it gains riot.";
    }

    private DomriChaosBringerEffect(DomriChaosBringerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DomriChaosBringerEffect copy() {
        return new DomriChaosBringerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        BasicManaEffect manaEffect = player.chooseUse(Outcome.PutManaInPool, "Choose red or green mana", "", "Red", "Green", source, game) ? new BasicManaEffect(Mana.RedMana((int)1)) : new BasicManaEffect(Mana.GreenMana((int)1));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new DomriChaosBringerTriggeredAbility(source.getSourceId(), game.getTurnNum()), source);
        return manaEffect.apply(game, source);
    }
}

