/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.cards.d.DomriChaosBringAddRiotToSpellEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;

class DomriChaosBringerTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID spellId;
    private final int turnNumber;

    DomriChaosBringerTriggeredAbility(UUID spellId, int turnNumber) {
        super(null, Duration.Custom, true);
        this.spellId = spellId;
        this.turnNumber = turnNumber;
        this.usesStack = false;
    }

    private DomriChaosBringerTriggeredAbility(DomriChaosBringerTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.spellId = ability.spellId;
        this.turnNumber = ability.turnNumber;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_PAID;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.spellId)) {
            return false;
        }
        if (game.getTurnNum() != this.turnNumber) {
            return false;
        }
        MageObject mo = game.getObject(event.getTargetId());
        if (mo == null || !mo.isCreature(game)) {
            return false;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getTargetId());
        if (stackObject == null) {
            return false;
        }
        this.getEffects().clear();
        game.addEffect((ContinuousEffect)new DomriChaosBringAddRiotToSpellEffect(stackObject.getSourceId()), (Ability)this);
        return true;
    }

    public DomriChaosBringerTriggeredAbility copy() {
        return new DomriChaosBringerTriggeredAbility(this);
    }
}

