/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Arrays;
import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.BecomesSubtypeAllEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;

public final class DonAndresTheRenegade
extends CardImpl {
    private static final FilterCreaturePermanent creatureFilter = new FilterCreaturePermanent();
    private static final FilterSpell spellFilter;

    public DonAndresTheRenegade(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{U}{B}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.VAMPIRE);
        this.subtype.add((Object)SubType.PIRATE);
        this.power = new MageInt(4);
        this.toughness = new MageInt(3);
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostControlledEffect(2, 2, Duration.WhileOnBattlefield, (FilterPermanent)creatureFilter, false).setText("Each creature you control but don't own gets +2/+2"));
        ability.addEffect((Effect)new GainAbilityControlledEffect((Ability)new MenaceAbility(), Duration.WhileOnBattlefield, (FilterPermanent)creatureFilter).setText(", has menace"));
        ability.addEffect((Effect)new GainAbilityControlledEffect((Ability)DeathtouchAbility.getInstance(), Duration.WhileOnBattlefield, (FilterPermanent)creatureFilter).setText(" and deathtouch"));
        ability.addEffect((Effect)new BecomesSubtypeAllEffect(Duration.WhileOnBattlefield, Arrays.asList(SubType.PIRATE), creatureFilter, false).setText(", and is a Pirate in addition to its other types."));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new SpellCastControllerTriggeredAbility((Effect)new CreateTokenEffect((Token)new TreasureToken(), 2, true), spellFilter, false));
    }

    private DonAndresTheRenegade(DonAndresTheRenegade card) {
        super((CardImpl)card);
    }

    public DonAndresTheRenegade copy() {
        return new DonAndresTheRenegade(this);
    }

    static {
        creatureFilter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        creatureFilter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getOwnerPredicate());
        spellFilter = new FilterSpell("a noncreature spell you don't own");
        spellFilter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        spellFilter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getOwnerPredicate());
    }
}

