/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DoubleTroubleEffect
extends OneShotEffect {
    DoubleTroubleEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the power of each creature you control until end of turn";
    }

    private DoubleTroubleEffect(DoubleTroubleEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoubleTroubleEffect copy() {
        return new DoubleTroubleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            int power = permanent.getPower().getValue();
            if (power == 0) continue;
            game.addEffect(new BoostTargetEffect(power, 0).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

